---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：24-コア層（Core Layers）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **Dense.build/callの詳細実装**：core.pyの後半部分のため未確認
  2. **ActivityRegularizationの存在**：core.pyに含まれる可能性があるが未確認

## 2) 参照した情報（Evidence一覧）
- E-01: `tensorflow/python/keras/layers/core.py` 行69-132（Masking）
- E-02: `tensorflow/python/keras/layers/core.py` 行135-234（Dropout）
- E-03: `tensorflow/python/keras/layers/core.py` 行237-390（SpatialDropout1D/2D/3D）
- E-04: `tensorflow/python/keras/layers/core.py` 行393-434（Activation）
- E-05: `tensorflow/python/keras/layers/core.py` 行437-548（Reshape）
- E-06: `tensorflow/python/keras/layers/core.py` 行551-605（Permute）
- E-07: `tensorflow/python/keras/layers/core.py` 行608-692（Flatten）
- E-08: `tensorflow/python/keras/layers/core.py` 行695-737（RepeatVector）
- E-09: `tensorflow/python/keras/layers/core.py` 行740-998（Lambda）
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` 行25

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Maskingはmask_valueでタイムステップをスキップ | E-01 (行115-124) | ○ |
| C-02 | Dropout rateは0-1の範囲 | E-02 (行188-190) | ○ |
| C-03 | Dropout学習時のみ適用 | E-02 (行209-222) | ○ |
| C-04 | SpatialDropout1Dはnoise_shape=(B,1,C) | E-03 (行272-275) | ○ |
| C-05 | Activation: activations.get()で取得 | E-04 (行423) | ○ |
| C-06 | Reshape: -1で未知次元を推論 | E-05 (行480-522) | ○ |
| C-07 | Flatten: channels_first時に転置 | E-07 (行644-652) | ○ |
| C-08 | Flatten: eager modeでconstant_op高速化 | E-07 (行654-658) | ○ |
| C-09 | RepeatVector: nは整数のみ | E-08 (行723-724) | ○ |
| C-10 | Lambda: GradientTapeで変数追跡 | E-09 (行900-903) | ○ |
| C-11 | Lambda: 追跡外変数の作成は禁止 | E-09 (行917-928) | ○ |
| C-12 | Lambda: 追跡外変数の使用は警告 | E-09 (行930-944) | ○ |
| C-13 | Permute: dims指定で次元並替え | E-06 (行581-605) | ○ |
| C-14 | _keras_maskでマスク伝播 | E-01 (行123) | ○ |
| C-15 | Dense: matmul + bias + activation | **根拠不足** | △ |
| C-16 | Dense: スパース入力対応 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Dense層のbuild/call実装はcore.pyの後半（推定1000行目以降）にあるが読み込み範囲外
  - 候補：`tensorflow/python/keras/layers/core.py` 行1000以降
- ActivityRegularization等の追加コア層が存在する可能性

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Dropout, Masking, Flatten等の主要層は確認済み
- 1: 中リスク - Dense層の詳細実装は追加確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Dense層のbuild/callが設計書記載と一致するか確認
- [ ] core.pyに含まれる全レイヤーが網羅されているか確認
- [ ] Lambda層のセキュリティ注意事項が十分か確認
